% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_ume_formula_library.R
\name{create_ume_formula_library}
\alias{create_ume_formula_library}
\title{Create a molecular formula library for UME}
\usage{
create_ume_formula_library(
  max_formula,
  min_formula = "C1H1",
  lib_version = 99,
  masses = ume::masses,
  max_mass = 152,
  ratio_filter = TRUE,
  heu_filter = TRUE,
  max_oc = 1.2,
  max_hc = 3.1,
  max_nc = 1.3,
  max_pc = 0.3,
  max_sc = 0.8,
  verbose = FALSE
)
}
\arguments{
\item{max_formula}{Character. Maximum element/isotope counts, e.g.
"C20H40O10" or "C1000\[13C1\]H2000".}

\item{min_formula}{Character. Minimum element/isotope counts (default "C1H1").}

\item{lib_version}{Integer. Library version identifier (default 99).}

\item{masses}{A data.table. Defaults to \code{ume::masses} (based on NIST data)
containing isotope information for elements, including nominal and exact mass,
relative abundance, and Hill system order.}

\item{max_mass}{Numeric. Maximum allowed exact mass.}

\item{ratio_filter}{Logical. Apply O/C, H/C, N/C, P/C, S/C filters.}

\item{heu_filter}{Logical. Apply Kind - Fiehn heuristic rules.}

\item{max_oc}{Maximum oxygen / carbon ratio in a molecule; (UM_orig: 1.5;   7 rules: 1.2)}

\item{max_hc}{Maximum hydrogen / carbon ratio in a molecule; (UM_orig: ;   7 rules: 1.2)}

\item{max_nc}{Maximum nitrogen / carbon ratio in a molecule; (UM_orig: 0.5;   7 rules: 1.3)}

\item{max_pc}{Maximum phosphorus / carbon ratio in a molecule; (UM_orig: 3;   7 rules: 0.3)}

\item{max_sc}{Maximum sulfur / carbon ratio in a molecule; (UM_orig: 4;   7 rules: 0.8)}

\item{verbose}{Logical. Print progress messages.}
}
\value{
A \code{data.table} containing the generated molecular formula library.
The returned object has class \code{"ume_library"} and includes one row per
molecular formula, with columns for:
\itemize{
\item elemental and isotopic counts (e.g., \verb{12C}, \verb{13C}, \verb{1H}, \verb{16O}, ...)
\item double bond equivalent (\code{dbe})
\item exact mass (\code{mass})
\item molecular formula string (\code{mf})
\item a unique versioned key (\code{vkey})
}

Additional metadata is stored as attributes:
\itemize{
\item \code{"lib_version"}: numeric version identifier
\item \code{"min_formula"}: user-supplied minimum formula
\item \code{"max_formula"}: user-supplied maximum formula
\item \code{"max_mass"}: maximum allowed exact mass
\item \code{"filters"}: list describing applied ratio and heuristic filters
\item \code{"call"}: the matched function call
}

The object inherits from both \code{"ume_library"} and \code{"data.table"}.
}
\description{
Generates all combinations of element / isotope counts between
\code{min_formula} and \code{max_formula}, filtered by mass, DBE, element ratios,
and heuristic rules (Kind & Fiehn 2007).
}
\references{
Kind T., Fiehn O. (2007). Seven Golden Rules for heuristic filtering of
molecular formulas obtained by accurate mass spectrometry.
\emph{BMC Bioinformatics}, \strong{8}, 105.
\doi{10.1186/1471-2105-8-105}
}
