#' Unified UME Theme for All uplot_* Functions
#'
#' @title theme_uplots
#' @description
#' Applies a clean UME-style theme used across all uplot_* visualisations.
#' Matches the styling of `uplot_vk()`: white background, no grid,
#' black axis lines, black ticks, and consistent font sizing.
#'
#' @param base_size Numeric base font size (default = 12).
#' @param base_family Base font family.
#'
#' @return A ggplot2 theme object.
#' @export
theme_uplots <- function(base_size = 12, base_family = "") {

  ggplot2::theme_minimal(base_size = base_size, base_family = base_family) %+replace%

    ggplot2::theme(

      # Backgrounds
      panel.background = ggplot2::element_rect(fill = "white", color = NA),
      plot.background  = ggplot2::element_rect(fill = "white", color = NA),

      # Remove gridlines
      panel.grid.major = ggplot2::element_blank(),
      panel.grid.minor = ggplot2::element_blank(),

      # Axis styling (VK style)
      axis.line  = ggplot2::element_line(color = "black", linewidth = 0.6),
      axis.ticks = ggplot2::element_line(color = "black", linewidth = 0.6),

      # Font sizes
      axis.text  = ggplot2::element_text(size = base_size,  color = "black"),
      axis.title = ggplot2::element_text(size = base_size + 3, color = "black"),

      legend.title = ggplot2::element_text(size = base_size + 1),
      legend.text  = ggplot2::element_text(size = base_size),

      plot.title = ggplot2::element_text(size = base_size + 4, face = "bold"),
      plot.caption = ggplot2::element_text(
        size = base_size - 2,
        face = "italic",
        hjust = 1,
        color = "gray40"
      ),

      # sane margins
      plot.margin = ggplot2::margin(t = 10, r = 10, b = 10, l = 10)
    )
}
