% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/knitFig.R
\name{knitFig}
\alias{knitFig}
\title{Easily knit a custom figure fragment}
\usage{
knitFig(
  plotToDraw,
  template = getOption("ufs.knitFig.template", NULL),
  figWidth = ufs::opts$get("ggSaveFigWidth"),
  figHeight = ufs::opts$get("ggSaveFigHeight"),
  figCaption = "A plot.",
  chunkName = NULL,
  returnRaw = FALSE,
  catPlot = ufs::opts$get("knitFig.catPlot"),
  ...
)
}
\arguments{
\item{plotToDraw}{The plot to draw, e.g. a \code{\link[ggplot2:ggplot]{ggplot2::ggplot()}} plot.}

\item{template}{A character value with the \code{\link[knitr:knit_expand]{knitr::knit_expand()}}
template to use.}

\item{figWidth}{The width to set for the figure (in inches).}

\item{figHeight}{The height to set for the figure (in inches).}

\item{figCaption}{The caption to set for the figure.}

\item{chunkName}{Optionally, the name for the chunk. To avoid problems
because multiple chunks have the name "\code{{unnamed-chunk-1}}", if no chunk
name is provided, \code{\link[digest:digest]{digest::digest()}} is used to generate an MD5-hash from
\code{\link[base:Sys.time]{base::Sys.time()}}.}

\item{returnRaw}{Whether to \code{\link[=cat]{cat()}} the result (\code{TRUE}) or whether
to return it as \code{\link[knitr:asis_output]{knitr::asis_output()}} object (\code{FALSE}).}

\item{catPlot}{Whether to use the \code{\link[base:cat]{base::cat()}} function to print the
code for the plot, and return the result invisibly. If not, the result is
returned visible, and so probably printed anyway.}

\item{\dots}{Any additional arguments are passed on to
\code{\link[knitr:knit_expand]{knitr::knit_expand()}}.}
}
\value{
This function returns nothing, but uses \code{\link[knitr:knit_expand]{knitr::knit_expand()}}
and \code{\link[knitr:knit]{knitr::knit()}} to \code{\link[base:cat]{base::cat()}} the result.
}
\description{
This function was written to make it easy to knit figures with different, or
dynamically generated, widths and heights (and captions) in the same chunk
when working with R Markdown.
}
\examples{
\dontrun{
  ufs::knitFig(
    ufs::ggBoxplot(
      mtcars,
      'mpg'
    )
  )
}
}
\seealso{
\code{\link[knitr:knit_expand]{knitr::knit_expand()}} and \code{\link[knitr:knit]{knitr::knit()}}
}
\author{
Gjalt-Jorn Peters

Maintainer: Gjalt-Jorn Peters \href{mailto:ufs@opens.science}{ufs@opens.science}
}
\keyword{utilities}
