% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/descr.R
\name{descr}
\alias{descr}
\alias{descriptives}
\alias{descr.default}
\alias{print.descr}
\alias{pander.descr}
\alias{as.data.frame.descr}
\alias{descr.data.frame}
\title{descr (or descriptives)}
\usage{
descr(
  x,
  digits = 4,
  errorOnFactor = FALSE,
  include = c("central tendency", "spread", "range", "distribution shape", "sample size"),
  maxModes = 1,
  t = FALSE,
  conf.level = 0.95,
  quantileType = 2
)

\method{descr}{default}(
  x,
  digits = 4,
  errorOnFactor = FALSE,
  include = c("central tendency", "spread", "range", "distribution shape", "sample size"),
  maxModes = 1,
  t = FALSE,
  conf.level = 0.95,
  quantileType = 2
)

\method{print}{descr}(
  x,
  digits = attr(x, "digits"),
  t = attr(x, "transpose"),
  row.names = FALSE,
  ...
)

\method{pander}{descr}(x, headerPrefix = "", headerStyle = "**", ...)

\method{as.data.frame}{descr}(x, row.names = NULL, optional = FALSE, ...)

\method{descr}{data.frame}(x, ...)
}
\arguments{
\item{x}{The vector for which to return descriptives.}

\item{digits}{The number of digits to round the results to when showing
them.}

\item{errorOnFactor}{Whether to show an error when the vector is a factor,
or just show the frequencies instead.}

\item{include}{Which elements to include when showing the results.}

\item{maxModes}{Maximum number of modes to display: displays "multi" if more
than this number of modes if found.}

\item{t}{Whether to transpose the dataframes when printing them to the
screen (this is easier for users relying on screen readers).}

\item{conf.level}{Confidence of confidence interval around the mean in the
central tendency measures.}

\item{quantileType}{The type of quantiles to be used to compute the
interquartile range (IQR). See \code{\link{quantile}} for more information.}

\item{row.names}{Whether to show row names (\code{TRUE}) or not (\code{FALSE}).}

\item{...}{Additional arguments are passed to the default \code{print} and
\code{pander} methods.}

\item{headerPrefix}{The prefix for the heading; can be used to insert
hashes (\verb{#}) to create Markdown headings.}

\item{headerStyle}{A string to insert before and after the heading (to
make stuff bold or italic in Markdown).}

\item{optional}{Provided for compatibility with the default \code{\link[=as.data.frame]{as.data.frame()}}
method - see that help page for details.}
}
\value{
A list of dataframes with the requested values.
}
\description{
This function provides a number of descriptives about your data, similar to
what SPSS's DESCRIPTIVES (often called with DESCR) does.
}
\details{
Note that R (of course) has many similar functions, such as
\code{\link{summary}}, \code{\link[psych:describe]{psych::describe()}} in the excellent
\link[psych:00.psych-package]{psych::psych} package.

The Hartigans' Dip Test may be unfamiliar to users; it is a measure of uni-
vs. multidimensionality, computed by \code{\link[diptest:dip.test]{diptest::dip.test()}} from the
\code{dip.test} package. Depending on the sample size, values over
.025 can be seen as mildly indicative of multimodality, while values over
.05 probably warrant closer inspection (the p-value can be obtained using
\code{\link[diptest:dip.test]{diptest::dip.test()}}; also see Table 1 of Hartigan & Hartigan (1985) for
an indication as to critical values).
}
\examples{

descr(mtcars$mpg);

}
\references{
Hartigan, J. A.; Hartigan, P. M. The Dip Test of Unimodality.
Ann. Statist. 13 (1985), no. 1, 70--84. doi:10.1214/aos/1176346577.
https://projecteuclid.org/euclid.aos/1176346577.
}
\seealso{
\code{\link{summary}}, \code{\link[psych:describe]{psych::describe()}}
}
\author{
Gjalt-Jorn Peters

Maintainer: Gjalt-Jorn Peters \href{mailto:ufs@opens.science}{ufs@opens.science}
}
\keyword{univariate}
