test_that("prepare_data_for_modelling works correctly", {
  env_data_daily <- data.table::data.table(
    date = seq(
      from = as.POSIXct("2021-01-01 00:00:00"), by = "day",
      length.out = 8
    ),
    Komponente = c("GLO", "TMP", "RFE", "WIG", "WIR", "LDR", "TMP", "NO2"),
    Wert = 1:8,
    Station = "Station1",
    part = "part1",
    Komponente_txt = c(
      "Global Radiation", "Temperature", "Relative Humidity",
      "Wind Gust",
      "Wind Direction", "Longwave Downward Radiation",
      "Temperature", "NO2"
    ),
    year = 2021,
    day = as.POSIXct(rep("2021-01-01", 8))
  )
  params <- list(
    target = "NO2", # Define the target parameter
    meteo_variables = c("GLO", "TMP", "RFE", "WIG", "WIR", "LDR")
  )

  dt_prepared <- prepare_data_for_modelling(env_data_daily, params)

  expect_s3_class(dt_prepared, "data.table")
  expect_true(all(c(
    "value", "date_unix", "hour", "day_julian",
    "weekday", "date", "GLO", "TMP", "RFE", "WIG", "WIR", "LDR"
  )
  %in% colnames(dt_prepared)))
  expect_equal(nrow(dt_prepared), 1)
})
