% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_preprocessing.R
\name{scale_data}
\alias{scale_data}
\title{Standardize Training and Application Data}
\usage{
scale_data(train_data, apply_data)
}
\arguments{
\item{train_data}{A data frame containing the training dataset to be
standardized. It must contain numeric columns.}

\item{apply_data}{A data frame  containing the dataset to which the scaling
from \code{train_data} will be applied.}
}
\value{
A list containing the following elements:
\item{train}{The standardized training data.}
\item{apply}{The \code{apply_data} scaled using the means and standard deviations
from the \code{train_data}.}
\item{means}{The means of the numeric columns in \code{train_data}.}
\item{sds}{The standard deviations of the numeric columns in \code{train_data}.}
}
\description{
This function standardizes numeric columns of the \code{train_data} and applies
the same scaling (mean and standard deviation) to the corresponding columns
in \code{apply_data}. It returns the standardized data along with the scaling
parameters (means and standard deviations). This is particularly important
for neural network approaches as they tend to be numerically unstable and
deteriorate otherwise.
}
\examples{
data(mock_env_data)
detrended_list <- list(
  train = mock_env_data[1:80, ],
  apply = mock_env_data[81:100, ]
)
scale_result <- scale_data(
  train_data = detrended_list$train,
  apply_data = detrended_list$apply
)
scaled_train <- scale_result$train
scaled_apply <- scale_result$apply
}
