% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/twotrials.R
\name{plot.twotrials}
\alias{plot.twotrials}
\title{Plot method for class \code{"twotrials"}}
\usage{
\method{plot}{twotrials}(
  x,
  xlim = c(min(x$isummaries$lower), max(x$isummaries$upper)),
  two.sided = FALSE,
  plot = TRUE,
  ...
)
}
\arguments{
\item{x}{Object of class \code{"twotrials"}}

\item{xlim}{x-axis limits. Defaults to the confidence interval range of trial
1 and trial 2}

\item{two.sided}{Logical indicating whether the p-value functions should be
converted to a two-sided p-value function via the centrality function
2min(p, 1 - p). Defaults to \code{FALSE}}

\item{plot}{Logical indicating whether p-value functions should be plotted.
Defaults to \code{TRUE}}

\item{...}{Other arguments (for consistency with the generic)}
}
\value{
Plots combined p-value functions and invisibly returns a data frame
    containing the data underlying the plot
}
\description{
Plot method for class \code{"twotrials"}
}
\examples{
## logRR estimates from RESPIRE trials
res <- twotrials(null = 0, t1 = -0.4942, t2 = -0.1847, se1 = 0.1833, se2 = 0.1738,
                 alternative = "less", level = 0.95)
plot(res) # one-sided p-value functions
plot(res, two.sided = TRUE) # two-sided p-value functions

}
\seealso{
\code{\link{twotrials}}
}
\author{
Samuel Pawel
}
