% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pMA.R
\name{muMA}
\alias{muMA}
\title{Combined estimation function from fixed-effect meta-analysis}
\usage{
muMA(a = 0.5, t1, t2, se1, se2, alternative = "greater", ...)
}
\arguments{
\item{a}{P-value function quantile corresponding to the parameter estimate.
Defaults to \code{0.5}, which corresponds to the median estimate. Set
to \code{a = c(0.025, 0.975)} to obtain limits of a 95\% confidence
interval}

\item{t1}{Parameter estimate from trial 1}

\item{t2}{Parameter estimate from trial 2}

\item{se1}{Standard error of the parameter estimate from trial 1}

\item{se2}{Standard error of the parameter estimate from trial 2}

\item{alternative}{One-sided alternative hypothesis. Can be either
\code{"greater"} or \code{"less"}. Defaults to \code{"greater"}}

\item{...}{Additional arguments (for consistency with other estimation
functions)}
}
\value{
The parameter estimate based on fixed-effect meta-analysis
}
\description{
This function computes parameter estimates from the combined
    estimation function based on fixed-effect meta-analysis
}
\examples{
## 95\% CI and median estimate for logRR in RESPIRE trials
muMA(a = c(0.975, 0.5, 0.025), t1 = -0.4942, t2 = -0.1847, se1 = 0.1833,
     se2 = 0.1738, alternative = "less")

}
\seealso{
\code{\link{muMA}}
}
\author{
Samuel Pawel
}
