% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ss2MixedContinuousBinary.R
\name{ss2MixedContinuousBinary}
\alias{ss2MixedContinuousBinary}
\title{Sample Size Calculation for Two Co-Primary Endpoints: One Continuous and One Binary}
\usage{
ss2MixedContinuousBinary(
  delta,
  sd,
  p1,
  p2,
  rho,
  r,
  alpha,
  beta,
  Test,
  nMC = 10000
)
}
\arguments{
\item{delta}{Mean difference for the continuous endpoint (group 1 - group 2)}

\item{sd}{Common standard deviation for the continuous endpoint}

\item{p1}{Probability of response in group 1 for the binary endpoint (0 < p1 < 1)}

\item{p2}{Probability of response in group 2 for the binary endpoint (0 < p2 < 1)}

\item{rho}{Biserial correlation between the latent continuous variable underlying
the binary endpoint and the observed continuous endpoint}

\item{r}{Allocation ratio n1/n2 where n1 is sample size for group 1}

\item{alpha}{One-sided significance level (typically 0.025 or 0.05)}

\item{beta}{Type II error rate (typically 0.1 or 0.2). Power = 1 - beta}

\item{Test}{Statistical testing method for the binary endpoint. One of:
\itemize{
\item \code{"AN"}: Asymptotic normal method without continuity correction
\item \code{"ANc"}: Asymptotic normal method with continuity correction
\item \code{"AS"}: Arcsine method without continuity correction
\item \code{"ASc"}: Arcsine method with continuity correction
\item \code{"Fisher"}: Fisher's exact test (uses sequential search)
}}

\item{nMC}{Number of Monte Carlo replications when Test = "Fisher" (default: 10000)}
}
\value{
A data frame with the following columns:
\item{delta}{Mean difference for continuous endpoint}
\item{sd}{Standard deviation for continuous endpoint}
\item{p1}{Response probability in group 1 for binary endpoint}
\item{p2}{Response probability in group 2 for binary endpoint}
\item{rho}{Biserial correlation}
\item{r}{Allocation ratio}
\item{alpha}{One-sided significance level}
\item{beta}{Type II error rate}
\item{Test}{Testing method used for binary endpoint}
\item{nMC}{Number of Monte Carlo replications (NA if Test != "Fisher")}
\item{n1}{Required sample size for group 1}
\item{n2}{Required sample size for group 2}
\item{N}{Total sample size (n1 + n2)}
}
\description{
Determines the sample size for a two-arm superiority trial with two co-primary
endpoints where one is continuous and one is binary, to achieve a specified
power at a given significance level.
}
\details{
This function implements the sample size calculation for mixed continuous-binary
co-primary endpoints following the methodology in Sozu et al. (2012).

The sequential search algorithm (Homma and Yoshida 2025, Algorithm 1) is used
for all testing methods:

\strong{Step 1:} Initialize with sample sizes from single endpoint formulas.

\strong{Step 2:} Use sequential search:
\itemize{
\item Calculate power at initial sample size
\item If power >= target: decrease n2 until power < target, then add 1 back
\item If power < target: increase n2 until power >= target
}

\strong{Step 3:} Return final sample sizes.

\strong{Biserial Correlation:}
The biserial correlation rho represents the correlation between the latent continuous
variable underlying the binary endpoint and the observed continuous endpoint. This is
not the same as the point-biserial correlation observed in the data.
}
\examples{
# Sample size calculation using asymptotic normal method
ss2MixedContinuousBinary(
  delta = 0.5,
  sd = 1,
  p1 = 0.6,
  p2 = 0.4,
  rho = 0.5,
  r = 1,
  alpha = 0.025,
  beta = 0.1,
  Test = 'AN'
)

# With continuity correction
ss2MixedContinuousBinary(
  delta = 0.5,
  sd = 1,
  p1 = 0.6,
  p2 = 0.4,
  rho = 0.5,
  r = 1,
  alpha = 0.025,
  beta = 0.1,
  Test = 'ANc'
)

\donttest{
# Fisher's exact test (computationally intensive)
ss2MixedContinuousBinary(
  delta = 0.5,
  sd = 1,
  p1 = 0.6,
  p2 = 0.4,
  rho = 0.5,
  r = 1,
  alpha = 0.025,
  beta = 0.1,
  Test = 'Fisher',
  nMC = 5000
)
}

}
\references{
Sozu, T., Sugimoto, T., & Hamasaki, T. (2012). Sample size determination in
clinical trials with multiple co-primary endpoints including mixed continuous
and binary variables. \emph{Biometrical Journal}, 54(5), 716-729.

Homma, G., & Yoshida, T. (2025). Exact power and sample size in clinical
trials with two co-primary binary endpoints. \emph{Statistical Methods in
Medical Research}, 34(1), 1-19.
}
