% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tvGarchKalmanPrint.R
\name{tvGarchKalmanPrint}
\alias{tvGarchKalmanPrint}
\title{Models tv-Garch Filter Kalman print outputs.}
\usage{
tvGarchKalmanPrint(
  x,
  series,
  c,
  alpha,
  beta,
  nsample = length(series),
  type = c("polynomial", "NoLineal", "trigonometric"),
  exponentes,
  trig,
  arg,
  trace.log = FALSE,
  predict
)
}
\arguments{
\item{x}{Vector of coefficents to fit.}

\item{series}{Time series.}

\item{c}{Vector containing coefficents of c.}

\item{alpha}{Vector containing coefficents of alpha.}

\item{beta}{Vector containing coefficents of beta.}

\item{nsample}{Value of time series length.}

\item{type}{Vector of function type for c, alpha and beta.}

\item{exponentes}{Vector for exponenets in NoLineal.}

\item{trig}{Type of trigonometric function.}

\item{arg}{Value of argument for the trigonometric function.}

\item{trace.log}{Variable to print names of coefficients.}

\item{predict}{Value for time to generate predict.}
}
\value{
A data frame containing the following columns:
\itemize{
\item \code{X}: State vector of Kalman equations.
\item \code{Fm}: Value of MSE
\item \code{sigma}: Conditional variance.
\item \code{loglike}: Value of the loglike.
}
}
\description{
This function is designed to print the outputs of the tv-Garch model, which include the returns,
conditional variance, log-likelihood value, and mean squared error (MSE).
}
\examples{
data(ipsa)
ipsa<-diff(log(indipsa))
c<-c(0.05,0.05)
alpha<-c(0.05,0.05)
beta<-c(0.05,0.05)
type_fit<-c("trigonometric","trigonometric","trigonometric")
fit<-tvGarchKalmanFit(ipsa,c=c,alpha=alpha,beta=beta,type=type_fit,trig="cos",arg="3*(1-log(u))")
arg_model<-"3*(1-log(u))"
model<-tvGarchKalmanPrint(fit,ipsa,c=c,alpha=alpha,beta=beta,type=type_fit,trig="cos",arg=arg_model)
plot(ipsa,ylab="",xlim=c(2000,2015))
lines(ts(model$sigma, star=2000, freq=225), col="red", lwd=2)
lines(ts(model$sigma*(-1), star=2000, freq=225), col="red", lwd=2)
}
