% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tspredbench.R
\docType{data}
\name{EUNITE.Temp}
\alias{EUNITE.Temp}
\title{EUNITE Competition – Average Daily Temperatures}
\format{
A data frame with one numeric column and 1,461 rows (average daily temperature).
}
\source{
EUNITE Competition 2001 dataset (original competition website currently unavailable).
}
\usage{
data(EUNITE.Temp)
}
\description{
Average daily temperatures collected for the EUNITE load-forecasting competition.
Data Type: Meteorological measurements. Category: Benchmark. Observations: 1,461.
The series covers 1995-1998 and was used as an exogenous regressor for predicting maximum daily electrical loads.
Participants were asked to forecast January 1999 values.
}
\details{
Daily temperatures are commonly used as exogenous variables for load forecasting due to strong weather dependence.
This series aligns with the period covered by EUNITE.Loads.
}
\examples{
# Load daily temperature series
data(EUNITE.Temp)
# EUNITE.Temp <- loadfulldata(EUNITE.Temp)

# Plot temperature over time
ts.plot(EUNITE.Temp$Temperature, ylab = "Temperature (°C)", xlab = "Day",
        main = "EUNITE: Daily Temperature")
}
\references{
Chen, B.-J., Chang, M.-W., & Lin, C.-J. (2004). \emph{Load forecasting using support vector machines: a study on EUNITE competition 2001}. IEEE Transactions on Power Systems, 19(4), 1821-1830.
}
\keyword{benchmark}
\keyword{datasets}
