% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{cgarch_modelspec.tsgarch.multi_estimate}
\alias{cgarch_modelspec.tsgarch.multi_estimate}
\title{Copula GARCH model specification}
\usage{
\method{cgarch_modelspec}{tsgarch.multi_estimate}(
  object,
  dynamics = c("constant", "dcc", "adcc"),
  dcc_order = c(1, 1),
  transformation = c("parametric", "empirical", "spd"),
  copula = c("mvn", "mvt"),
  constant_correlation = c("pearson", "kendall", "spearman"),
  cond_mean = NULL,
  ...
)
}
\arguments{
\item{object}{an object of class \dQuote{tsgarch.multi_estimate}.}

\item{dynamics}{the type of correlation dynamics to use.}

\item{dcc_order}{the order of the dynamics in case of \dQuote{dcc} or \dQuote{adcc}
correlation models.}

\item{transformation}{the copula transformation to apply.}

\item{copula}{the copula distribution.}

\item{constant_correlation}{the constant correlation estimator to use. In the
case of the \dQuote{mvt} copula, only Kendall's tau is a valid choice.}

\item{cond_mean}{an optional matrix of the conditional mean for the series.}

\item{...}{additional arguments passed to the \code{\link[tsdistributions]{spd_modelspec}}
function in the case of the \dQuote{spd} transformation.}
}
\value{
an object of class \dQuote{cgarch.spec}.
}
\description{
Copula GARCH model specification
}
