% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as-tsibble.R
\name{update_tsibble}
\alias{update_tsibble}
\title{Update key and index for a tsibble}
\usage{
update_tsibble(
  x,
  key,
  index,
  regular = is_regular(x),
  validate = TRUE,
  .drop = key_drop_default(x)
)
}
\arguments{
\item{x}{A tsibble.}

\item{key}{<\code{\link[dplyr:dplyr_tidy_select]{tidy-select}}> Variable(s) that uniquely
determine time indices. \code{NULL} for an empty key, unquoted column names (e.g.
\code{x}) for a single variable, and \code{c()} for multiple variables (e.g. \code{c(x, y)}).
This argument also supports \link[tidyselect:language]{tidy-select expressions},
e.g. \code{\link[dplyr:reexports]{dplyr::starts_with()}}, \code{\link[dplyr:reexports]{dplyr::all_of()}}.}

\item{index}{<\code{\link[dplyr:dplyr_tidy_select]{tidy-select}}> A variable that contains
time indices. This is commonly an unquoted column name (e.g. \code{t}), but it can
also be a \link[tidyselect:language]{tidy-select expression}.}

\item{regular}{Regular time interval (\code{TRUE}) or irregular (\code{FALSE}). The
interval is determined by the greatest common divisor of the index column, if \code{TRUE}.}

\item{validate}{\code{TRUE} suggests to verify that each key or each combination
of key variables leads to unique time indices (i.e. a valid tsibble). If you
are sure that it's a valid input, specify \code{FALSE} to skip the checks.}

\item{.drop}{If \code{TRUE}, empty key groups are dropped.}
}
\description{
Update key and index for a tsibble
}
\details{
Unspecified arguments will inherit the attributes from \code{x}.
}
\examples{
# update index
library(dplyr)
pedestrian \%>\%
  group_by_key() \%>\%
  mutate(Hour_Since = Date_Time - min(Date_Time)) \%>\%
  update_tsibble(index = Hour_Since)

# update key: drop the variable "State" from the key
tourism \%>\%
  update_tsibble(key = c(Purpose, Region))
}
