% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/inspect_birthmonth.R
\name{inspect_birthmonth}
\alias{inspect_birthmonth}
\title{Inspect birthmonth-component of a string}
\usage{
inspect_birthmonth(code)
}
\arguments{
\item{code}{A character string containing a SGIC or similar code that may include a numeric birth month-component.}
}
\value{
A logical value: `TRUE` if the string contains only one valid birth month-component (between 01 and 12), otherwise `FALSE`.
}
\description{
Check whether a given string contains exactly one two-digit number that represents a valid month of the year (between 01 and 12). 
The string is assumed to be a code (e.g., a SGIC), which may include letters and digits.
}
\examples{
inspect_birthday("DEF66") # FALSE - 66 is not a valid month
inspect_birthday("GHI02") # TRUE - 02 (February) is a valid month
inspect_birthday("ABC12DEF10") # FALSE - Multiple numeric components
inspect_birthday("XYZ") # FALSE - No numeric component
inspect_birthday("JKL11") # TRUE - 11 (November) is a valid day
}
