% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{combined_iso}
\alias{combined_iso}
\title{Stable isotope data for lake trout, amphipods (benthic baseline; baseline 1)
and dreissenids (pelagic baseline; baseline 2),}
\format{
\code{data.frame} containing 117 rows and 13 variables
\describe{
\item{id}{row id number}
\item{common_name}{name of the spcies (i.e., Lake Trout)}
\item{ecoregion}{ecoregion where samples were collected}
\item{d13c}{observed values for \eqn{\delta^{13}}C of consumer}
\item{d15n}{observed values for \eqn{\delta^{15}}N of consumer}
\item{d13c_b1}{observed values for \eqn{\delta^{13}}C of baseline 1}
\item{d15n_b1}{observed values for \eqn{\delta^{15}}N of baseline 1}
\item{d13c_b2}{observed values for \eqn{\delta^{13}}C of baseline 2}
\item{d15n_b2}{observed values for \eqn{\delta^{15}}N of baseline 2}
\item{c1}{mean values for \eqn{\delta^{13}}C of baseline 1}
\item{n1}{mean values for \eqn{\delta^{15}}N of baseline 1}
\item{c2}{mean values for \eqn{\delta^{13}}C of baseline 2}
\item{n2}{mean values for \eqn{\delta^{15}}N of baseline 2}

}
}
\usage{
combined_iso
}
\description{
Stable isotope data (\eqn{\delta^{13}}C and
\eqn{\delta ^{15}}N) for lake trout collected from two ecoregions in
Lake Ontario. Values of \eqn{\delta ^{13}}C and
\eqn{\delta ^{15}}N for a benthic baseline (amphipods; baseline 1;
\code{d13c_b1} and \code{d15n_b1}) and  pelagic baseline
(dreissenids; baseline 2; \code{d13c_b2} and \code{d15n_b2}) with the means for each
baseline calculated (\code{c1},  \code{n1}, \code{c2}, and \code{n2}).
}
\keyword{datasets}
