% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/evaluate_aic.R
\name{evaluate_aic}
\alias{evaluate_aic}
\alias{evaluate_aic.default}
\alias{evaluate_aic.trending_model}
\alias{evaluate_aic.list}
\alias{evaluate_aic.trending_list}
\title{Generic for calculating the AIC}
\usage{
evaluate_aic(x, ...)

\method{evaluate_aic}{default}(x, ...)

\method{evaluate_aic}{trending_model}(x, data, as_tibble = FALSE, ...)

\method{evaluate_aic}{list}(x, data, ...)
}
\arguments{
\item{x}{An \R object.}

\item{...}{Not currently used.}

\item{data}{a \code{data.frame} containing data (including the response variable
and all predictors) used in the specified model.}

\item{as_tibble}{Should the result be returned as \link[tibble:tibble]{tibble}
(\code{as_tibble = TRUE}) or a list (\code{as_tibble = FALSE}).}
}
\value{
If \code{as_tibble = TRUE}, or the input is a list of models then the
output will be a \link[tibble:tibble]{tibble} with one row for each fitted
model columns corresponding to output generated with single model input.
}
\description{
\code{evaluate_aic()} is a a generic for evaluating the Akaike's
'An Information Criterion' for a given input
}
\details{
Specific methods are given for
\code{\link[trending:fit.trending_model]{trending_fit}} and lists of these
models.
}
\author{
Tim Taylor

#' @examples
x = rnorm(100, mean = 0)
y = rpois(n = 100, lambda = exp(1.5 + 0.5*x))
dat <- data.frame(x = x, y = y)
poisson_model <- glm_model(y ~ x , family = "poisson")
negbin_model <- glm_nb_model(y ~ x)

evaluate_aic(poisson_model, dat)
evaluate_aic(list(poisson_model, negbin_model), data = dat)
}
