% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/addtips.R
\name{addtips}
\alias{addtips}
\title{Compare and add tips into new treestructure object}
\usage{
addtips(trst, tre)
}
\arguments{
\item{trst}{Original treestructure fit that that will be updated.}

\item{tre}{A new tree (ape::phylo) which may contain samples not in trst.
This tree must be rooted, but does not need to be time-scaled or binary.}
}
\value{
A new treestructure fit.
}
\description{
Compares a new input tree to an old treestructure fit and merges tips into a
new treestructure object.
Tips in the new tree that are not in the new treestructure will be merged.
Merging is carried out based on a phylogenetic criterion. The new tips are
added to the cluster which shares its MRCA (most recent common ancestor).
}
\examples{
set.seed(072023)
# simulate two trees and bind them to simulate structure
tr1 <- ape::rcoal( 50 )
tr2 <- ape::rcoal( 100 )
tr1$tip.label <- gsub(tr1$tip.label, patt = 't', rep = 's')
tr1$edge.length <- tr1$edge.length*.5
tr1$root.edge <- 1
tr2$root.edge <- 1
tr <- ape::bind.tree(tr1, tr2, position = .5 ) |> ape::multi2di()

# subsample the tree to simulating missing tips and estimate structure
ex <- sample( tr$tip.label, size = 30, replace = FALSE)
tr0 <- ape::drop.tip( tr, ex )
(s0 <- treestructure::trestruct( tr0 ))

# assign structure to the previously missing tips
(s <- treestructure::addtips( s0, tr ))
}
\author{
Erik Volz
}
