% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parse-headers.R
\name{preprocess_headers}
\alias{preprocess_headers}
\title{Preprocess a set of header files found under \code{dir}}
\usage{
preprocess_headers(
  dir = R.home("include"),
  recursive = TRUE,
  pattern = c("\\\\.h$", "\\\\.H$"),
  cc = r_cc(),
  ccflags = NULL,
  ...
)
}
\arguments{
\item{dir}{Directory where header files will be searched.}

\item{recursive}{Logical; whether to search recursively.}

\item{pattern}{File name pattern(s) used to identify header files.}

\item{cc}{Compiler string; passed to \code{preprocess_header}.}

\item{ccflags}{Compiler flags; passed to \code{preprocess_header}.}

\item{...}{
  Arguments passed on to \code{\link[=parse_r_include_headers]{parse_r_include_headers}}
  \describe{
    \item{\code{preprocess}}{Run the C preprocessor (using R's configured CC) on
header files before parsing. Defaults to \code{FALSE}.}
    \item{\code{include_dirs}}{Additional directories to add to the include path for preprocessing. A character vector of directories.}
  }}
}
\value{
Named list of file => preprocessed text.
}
\description{
This helper calls \code{preprocess_header()} for each matching file in
\code{dir} and returns a named list with the path as the keys and the
preprocessed text as the values.
}
