% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parse-headers.R
\name{parse_r_include_headers}
\alias{parse_r_include_headers}
\title{Parse C header files for function declarations using tree-sitter}
\usage{
parse_r_include_headers(
  dir = R.home("include"),
  recursive = TRUE,
  pattern = c("\\\\.h$", "\\\\.H$"),
  preprocess = FALSE,
  cc = r_cc(),
  ccflags = NULL,
  include_dirs = NULL,
  ...
)
}
\arguments{
\item{dir}{Directory to search for header files. Defaults to
\code{R.home("include")}.}

\item{recursive}{Whether to search recursively for headers. Default
\code{TRUE}.}

\item{pattern}{File name pattern to match header files. Default is
\verb{\\.h$} and \verb{\\.H$}.}

\item{preprocess}{Run the C preprocessor (using R's configured CC) on
header files before parsing. Defaults to \code{FALSE}.}

\item{cc}{The C compiler to use for preprocessing. If \code{NULL} the
function queries \verb{R CMD config CC} and falls back to \code{Sys.getenv("CC")}
and the \code{cc} on PATH.}

\item{ccflags}{Extra flags to pass to the compiler when preprocessing.
If \code{NULL} flags are taken from \verb{R CMD config CFLAGS} and \verb{R CMD config CPPFLAGS}.}

\item{include_dirs}{Additional directories to add to the include path for preprocessing. A character vector of directories.}

\item{...}{
  Arguments passed on to \code{\link[=parse_headers_collect]{parse_headers_collect}}
  \describe{
    \item{\code{extract_params}}{Logical; whether to extract parameter types for functions. Default \code{FALSE}.}
    \item{\code{extract_return}}{Logical; whether to extract return types for functions. Default \code{FALSE}.}
  }}
}
\value{
A data frame with columns \code{name}, \code{file}, \code{line}, and \code{kind}
(either 'declaration' or 'definition').
}
\description{
This utility uses the C language provided by this package and the
treesitter parser to find function declarations and definitions in
C header files. The default \code{dir} is \code{R.home("include")}, which is
typically where R's headers live.
}
\examples{
if (requireNamespace("treesitter", quietly = TRUE)) {
  # Parse a small header file from a temp dir
  tmp <- tempdir()
  path <- file.path(tmp, "example.h")
  writeLines(c(
    "int foo(int a);",
    "static inline int bar(void) { return 1; }"
  ), path)
  parse_r_include_headers(dir = tmp)
}
}
