% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/treedater0.R
\name{gibbs_jitter}
\alias{gibbs_jitter}
\title{Sample node dates conditional on root time using Gibbs sampling and date prior}
\usage{
gibbs_jitter(
  dtr,
  iter = 1000,
  burn_pc = 20,
  returnTrees = 10,
  res = 100,
  report = 10
)
}
\arguments{
\item{dtr}{A treedater fit}

\item{iter}{Number of iterations (every node time is resampled in each iteration )}

\item{burn_pc}{Remove this proportion as burn-in}

\item{returnTrees}{Integer number of trees to return.}

\item{res}{Time resolution for proposing new node times}

\item{report}{Report progress after this many iterations. Set to Inf to turn it off}
}
\value{
A list of treedater trees
}
\description{
This function is useful for 'smoothing out' time trees that have many adjacent small branch lengths (essential polytomies). It returns a list of smoothed trees.
}
\examples{
\dontrun{
# make a random tree:
tre <- ape::rtree(50)
# sample times based on distance from root to tip:
sts <- setNames( ape::node.depth.edgelength( tre )[1:ape::Ntip(tre)], tre$tip.label)
# modify edge length to represent evolutionary distance with rate 1e-3:
tre$edge.length <- tre$edge.length * 1e-3
# treedater:
td <- dater( tre, sts =sts, clock='strict', s = 1000, omega0=.0015 )
gibbs_jitter( td )
}
}
