% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modifiers.R
\name{modifiers}
\alias{modifiers}
\alias{branch.length}
\alias{selection}
\alias{speciation}
\alias{branch.length.trait}
\alias{speciation.trait}
\title{Modifiers}
\usage{
modifiers(bd.params = NULL, lineage = NULL, trait.values = NULL,
                     modify.fun = NULL)
}
\arguments{
\item{bd.params}{A named list of birth death parameters (see details).}

\item{lineage}{A named list containing the lineage data (see details).}

\item{trait.values}{A matrix containing the trait values (see details).}

\item{modify.fun}{A list of internals functions that can modified by \code{events} (see details).}
}
\value{
These functions returns either \code{"numeric"} or \code{"logical"} values to be passed to \code{\link{make.modifiers}} and \code{\link{treats}}.
}
\description{
Different modifiers for the birth death process implemented in treats.
}
\details{
\code{bd.params} can be either a named list of parameter values (e.g. \code{list("extinction" = 0, "speciation" = 1)}) but it is typically handled internally from a \code{"treats"} \code{"bd.params"} object.

\code{modifiers} are functions passed to the birth death process in \code{\link{treats}} to either generate the branch length (named \code{branch.length} and similar) or to decide whether to speciate or go extinct (named \code{speciation} and similar).

For user defined functions, the \code{modifiers} \emph{must} have at least the arguments described above. For safety, we suggest setting these arguments to \code{NULL}.

The pre-build \code{modifiers} in the \code{treats} package are (so far):

\itemize{

     \item \code{branch.length} the simple branch length generator that randomly gets a numeric value drawn from the exponential distribution (\code{\link[stats]{rexp}}) with a rate equal to the number of taxa (\code{lineage$n * bd.params$speciation + bd.params$extinction}).

     \item \code{branch.length.trait} a modification of the \code{branch.length} \code{modifier} where the resulting branch length is changed by \code{modify.fun$modify} if the parent trait(s) meet the condition \code{modify.fun$condition}.

     \item \code{selection} a function returning a randomly sampled integer among the number of taxa available.

     \item \code{speciation} a function returning \code{TRUE} (speciation) if a random uniform number (\code{\link[stats]{runif}}) is smaller than the ratio of speciation by speciation and extinction (\code{bd.params$speciation / (bd.params$speciation) + bd.params$extinction}). If it's bigger, the function returns \code{FALSE} (exinction).

     \item \code{speciation.trait} a modification of the \code{speciation} \code{modifier} where the random uniform number is changed by \code{modify.fun$modify} if the parent trait(s) meet the condition \code{modify.fun$condition}.

 }

More details about the \code{modifiers} functions is explained in the \code{treats} manual: \url{http://tguillerme.github.io/treats}.
}
\examples{
## These functions should be fed to the make.modifiers function to create
## modifiers for treats objects. For example, the following sets specifies that
## the branch length should be generated using the branch.length.trait function
## the selection using the selection function and the speciation using the
## speciation.trait function:
my_modifiers <- make.modifiers(branch.length = branch.length.trait,
                               selection     = selection,
                               speciation    = speciation.trait)

## Creating a treats simulation using these modifiers
treats(stop.rule = list(max.taxa = 20),
     traits = make.traits(),
     modifiers = my_modifiers)

}
\seealso{
\code{\link{treats}} \code{\link{make.modifiers}}
}
\author{
Thomas Guillerme
}
