% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/setup_modules.R
\name{check_nvidia_gpu}
\alias{check_nvidia_gpu}
\title{Install Necessary Python Modules}
\usage{
check_nvidia_gpu()
}
\description{
Installs required Python modules for the \{transforEmotion\} package, using uv
for fast, reproducible environments. Optionally detects GPU and can add
GPU-oriented packages.
}
\details{
This function performs the following steps:
\itemize{
  \item Detects NVIDIA GPU availability automatically
  \item Installs core modules including transformers, torch, tensorflow, and other dependencies
  \item For GPU systems, adds GPU-specific packages (and optional extras via \code{setup_gpu_modules()})
}

The function declares Python requirements via \code{\link[reticulate]{py_require}},
which uses uv to resolve and cache an ephemeral environment on first use. No
conda/Miniconda is required.
}
\note{
For GPU support, NVIDIA drivers must be properly installed on your system. If
you need vendor-specific wheels (e.g., for CUDA), configure package indexes
prior to calling this function (see Notes in documentation).
}
\author{
Alexander P. Christensen <alexpaulchristensen@gmail.com>
}
