% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dgps.R
\name{dgp_dicp}
\alias{dgp_dicp}
\title{Simple data-generating process for illustrating tramicp}
\usage{
dgp_dicp(
  n = 1000,
  K = 6,
  nenv = 2,
  bx3 = stats::rnorm(1),
  ge = stats::rnorm(nenv),
  ae = stats::rnorm(nenv),
  mod = "polr",
  interacting = FALSE,
  rm_censoring = TRUE,
  cfb = c(-3, 1.35),
  cfx = stats::rnorm(2),
  bx2x1 = stats::rnorm(1)
)
}
\arguments{
\item{n}{Sample size}

\item{K}{Number of outcome classes or order of Bernstein polynomial}

\item{nenv}{Number of environments}

\item{bx3}{Effect of Y on X3}

\item{ge}{Environment specific effect}

\item{ae}{Environment specific effect}

\item{mod}{Type of model}

\item{interacting}{Toggle baseline interaction with env}

\item{rm_censoring}{Remove censoring from simulated responses}

\item{cfb}{Baseline coefs}

\item{cfx}{Shift coefs}

\item{bx2x1}{coef from x2 to x1}
}
\value{
\code{data.frame} with simulated data
}
\description{
Simple data-generating process for illustrating tramicp
}
\details{
Simulates from X2 -> X1 -> Y -> X3, with E affecting X1, X2, X3, but
    not Y.
}
