% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/20_scheme.R
\name{fillShells}
\alias{fillShells}
\title{Assign image volumes to shells}
\usage{
fillShells(image, bValues)
}
\arguments{
\item{image}{A 4D diffusion-weighted image, whose mean volume intensities
will be used to cluster the acquisition into shells. It does not need to
already have gradient direction or b-value information associated with it.}

\item{bValues}{A numeric vector of unique b-values.}
}
\value{
A numeric vector expanding the original \code{bValues} to one value
  per volume of the \code{image}.
}
\description{
This function guesses the assignment of image volumes to shells, expanding
a list of unique b-values to one value per volume. This is achieved by
performing k-means clustering on the mean intensities of each volume. The
set of unique b-values must be known beforehand, and no sanity checking is
performed on the intensities for each shell except ordering.
}
\note{
The procedure performed by this function is a heuristic, and may
  produce inaccurate results if some shell b-values are close together, if
  there are many unique b-values, if the assumption of decreasing mean
  intensity with increasing b-value doesn't hold, etc. If the full
  acquisition scheme is known then it is alway better to specify it
  explicitly.
}
\references{
Please cite the following reference when using TractoR in your
work:

J.D. Clayden, S. Muñoz Maniega, A.J. Storkey, M.D. King, M.E. Bastin & C.A.
Clark (2011). TractoR: Magnetic resonance imaging and tractography with R.
Journal of Statistical Software 44(8):1-18. \doi{10.18637/jss.v044.i08}.
}
\author{
Jon Clayden
}
