% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nlm_track.R, R/optim_track.R,
%   R/trackopt_methods.R
\name{nlm_track}
\alias{nlm_track}
\alias{optim_track}
\alias{summary.trackopt}
\alias{autoplot.trackopt}
\title{Track numerical optimization}
\usage{
nlm_track(
  f,
  p,
  target = NULL,
  npar = NULL,
  gradient = NULL,
  hessian = NULL,
  ...,
  iterations_max = 100,
  tolerance = 1e-06,
  typsize = rep(1, length(p)),
  fscale = 1,
  ndigit = 12,
  stepmax = max(1000 * sqrt(sum((p/typsize)^2)), 1000),
  steptol = 1e-06,
  minimize = TRUE,
  verbose = FALSE
)

optim_track(
  f,
  p,
  target = NULL,
  npar = NULL,
  gradient = NULL,
  ...,
  iterations_max = 100,
  tolerance = 1e-06,
  lower = NULL,
  upper = NULL,
  method = c("Nelder-Mead", "BFGS", "CG", "L-BFGS-B", "SANN", "Brent"),
  control = list(),
  minimize = TRUE,
  verbose = FALSE
)

\method{summary}{trackopt}(object, ...)

\method{autoplot}{trackopt}(object, iteration = NULL, xlim = NULL, xlim2 = NULL, ...)
}
\arguments{
\item{f}{[\code{function}]\cr
A \code{function} to be optimized, returning a single \code{numeric} value.

The first argument of \code{f} should be a \code{numeric} of the same length
as \code{p}, optionally followed by any other arguments specified by
the \code{...} argument.

If \code{f} is to be optimized over an argument other than the first, or more
than one argument, this has to be specified via the \code{target} argument.}

\item{p}{[\code{numeric()}]\cr
The starting parameter values for the target argument(s).}

\item{target}{[\code{character()} | \code{NULL}]\cr
The name(s) of the argument(s) over which \code{f} gets optimized.

This can only be \code{numeric} arguments.

Can be \code{NULL} (default), then it is the first argument of \code{f}.}

\item{npar}{[\code{integer()}]\cr
The length(s) of the target argument(s).

Must be specified if more than two target arguments are specified via
the \code{target} argument.

Can be \code{NULL} if there is only one target argument, in which case \code{npar} is
set to be \code{length(p)}.}

\item{gradient}{[\code{function} | \code{NULL}]\cr
Optionally a \code{function} that returns the gradient of \code{f}.

The function call of \code{gradient} must be identical to \code{f}.}

\item{hessian}{[\code{function} | \code{NULL}]\cr
Optionally a \code{function} that returns the Hessian of \code{f}.

The function call of \code{hessian} must be identical to \code{f}.}

\item{...}{Additional arguments to be passed to \code{f} (and \code{gradient},
\code{hessian} if specified).}

\item{iterations_max}{[\code{integer(1)}]\cr
The maximum number of iterations before termination.}

\item{tolerance}{[\code{numeric(1)}]\cr
The minimum allowed absolute change in function value between two iterations
before termination.}

\item{typsize, fscale, ndigit, stepmax, steptol}{Arguments passed on to \code{\link[stats]{nlm}}.}

\item{minimize}{[\code{logical(1)}]\cr
Minimize?}

\item{verbose}{[\code{logical(1)}]\cr
Print progress?}

\item{lower, upper}{[\code{numeric()} | \code{NULL}]\cr
Optionally lower and upper parameter bounds.}

\item{method, control}{Arguments passed on to \code{\link[stats]{optim}}.

Elements \code{trace} and \code{maxit} are ignored in \code{control}.}

\item{object}{[\code{trackopt}]\cr
A \code{trackopt} object.}

\item{iteration}{[\code{integer(1)}]\cr
The iteration to plot.

If \code{NULL}, the last iteration is plotted.

This option is useful for creating animations, see
\url{https://bookdown.org/yihui/rmarkdown-cookbook/animation.html#ref-R-animation}.}

\item{xlim, xlim2}{[\code{numeric(2)}]\cr
Ranges for the first and second parameter to plot.

If \code{NULL}, they are derived from the parameter ranges in \code{object}.}
}
\value{
A \code{tibble} with iterations in rows.
}
\description{
\itemize{
\item \code{nlm_track()}: track \code{\link[stats]{nlm}} iterations
\item \code{optim_track()}: track \code{\link[stats]{optim}} iterations
\item \code{summary()}: summary of optimization track
\item \code{autoplot()}: visualization of optimization for one or two parameters
}
}
\examples{
himmelblau <- function(x) (x[1]^2 + x[2] - 11)^2 + (x[1] + x[2]^2 - 7)^2
track <- nlm_track(f = himmelblau, p = c(0, 0))
summary(track)
ggplot2::autoplot(track)
}
