% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/config_runtoxdrc.R
\name{toxdrc_qc}
\alias{toxdrc_qc}
\title{Set quality control options for the runtoxdrc pipeline.}
\usage{
toxdrc_qc(
  outlier.test = FALSE,
  cv.flag = TRUE,
  cvflag.lvl = 30,
  pctl.test = FALSE,
  pctl.lvl = 10,
  ref.label = "Control",
  pctl.label = 0,
  avg.resp = TRUE
)
}
\arguments{
\item{outlier.test}{Logical. Indicates if outliers should be
tested for and removed. Defaults to FALSE.}

\item{cv.flag}{Logical. Indicates if groups of the response
variable should be flagged if the CV exceeds `cvflag.lvl`.
Defaults to TRUE.}

\item{cvflag.lvl}{Numeric. The percent beyond which CV values are
flagged. Defaults to 30.}

\item{pctl.test}{Logical. Indicates if positive control/solvent
effects should be tested for. Defaults to FALSE.}

\item{pctl.lvl}{Numeric. Percent difference of the response in the
`ref.label` and `pctl.label` groups beyond which tests are
flagged. Defaults to 10.}

\item{ref.label}{Label used for the true control level.
Defaults to "Control".}

\item{pctl.label}{Label used for the positive control
level. Defaults to 0.}

\item{avg.resp}{Logical. Indicates if responses should be averaged
within each group. Defaults to TRUE.}
}
\value{
A named list containing the quality control configuration
 for use in [runtoxdrc()].
}
\description{
Control outlier detection, CV calculation, averaging of response
  variable, and testing for positive control effects.
}
\examples{
toxdrc_qc(outlier.test = TRUE, cvflag.lvl = 20)

}
\seealso{
[config_runtoxdrc], [runtoxdrc()], [pctl()], [removeoutliers()], [flagCV()]
}
