% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pctl.R
\name{pctl}
\alias{pctl}
\title{Check for positive control effect}
\usage{
pctl(
  dataset,
  Conc,
  reference_group = "Control",
  positive_group = 0,
  Response,
  max_diff = 10,
  list_obj = NULL,
  quiet = FALSE
)
}
\arguments{
\item{dataset}{A dataframe, containing the columns `Conc` and `Response`.}

\item{Conc}{Bare (unquoted) column name in `dataset` that groups the
`Response` variable.}

\item{reference_group}{Label used for the true control level.
Defaults to "Control".}

\item{positive_group}{Label used for the positive control
level. Defaults to 0.}

\item{Response}{Bare (unquoted) column name in `dataset` containing
the response variable.}

\item{max_diff}{Numeric. Percent difference of the response in the
`ref.label` and `pctl.label` groups beyond which tests are
flagged. Defaults to 10.}

\item{list_obj}{Optional. List object used for integration with
[runtoxdrc()].}

\item{quiet}{Logical. Indicates if results should be hidden. Defaults
to FALSE.}
}
\value{
A modified `dataset` with an additional column, `Validity`. If
 `list_obj` is provided, returns this within a list as
 `list_obj$dataset`, along with statistics of the positive and reference
 group as `list_obj$pctlresults`.
}
\description{
This function evaluates the difference between a two groups to determine if
 the difference between them exceeds a set amount. Commonly used to determine
 if a solvent introduces effects.
}
\examples{
pctl(
 dataset = toxresult,
 Conc = Conc,
 Response = RFU,
 reference_group = "Control",
 positive_group = "0"
)
}
