% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{toscca.core}
\alias{toscca.core}
\title{Sparse Canonical Correlation Analysis. Computation of CC via NIPALS with soft thresholding.}
\usage{
toscca.core(
  alphaInit,
  A,
  B,
  nonzero_a,
  nonzero_b,
  iter = 20,
  tol = 10^(-6),
  silent = FALSE
)
}
\arguments{
\item{alphaInit}{Character. Type initialisation for \deqn{\mathbf{\alpha}}.}

\item{A, B}{Data matrices.}

\item{nonzero_a, nonzero_b}{Numeric. Scalar or vector over the number of nonzeroes allowed for a correlation estimate.}

\item{iter}{Numeric. Maximum number of iterations. Default is 20.}

\item{tol}{Numeric. Tolerance threshold. Default is 10^6.}

\item{silent}{Logical. If FALSE, a progress bar will appear on the console. Default is FALSE.}
}
\value{
a list with the following elements:
}
\description{
Sparse Canonical Correlation Analysis. Computation of CC via NIPALS with soft thresholding.
}
