% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/models-mobilenetv3.R,
%   R/models-mobilenetv3_large.R
\name{model_mobilenet_v3}
\alias{model_mobilenet_v3}
\alias{model_mobilenet_v3_large}
\alias{model_mobilenet_v3_small}
\alias{model_mobilenet_v3_large_quantized}
\title{MobileNetV3 Model}
\usage{
model_mobilenet_v3_large(
  pretrained = FALSE,
  progress = TRUE,
  num_classes = 1000,
  width_mult = 1
)

model_mobilenet_v3_small(
  pretrained = FALSE,
  progress = TRUE,
  num_classes = 1000,
  width_mult = 1
)

model_mobilenet_v3_large_quantized(pretrained = FALSE, progress = TRUE, ...)
}
\arguments{
\item{pretrained}{(bool): If TRUE, returns a model pre-trained on ImageNet.}

\item{progress}{(bool): If TRUE, displays a progress bar of the download to
stderr.}

\item{num_classes}{number of output classes (default: 1000).}

\item{width_mult}{width multiplier for model scaling (default: 1.0).}

\item{...}{Other parameters passed to the model implementation.}
}
\description{
MobileNetV3 is a state-of-the-art lightweight convolutional neural network architecture
designed for mobile and embedded vision applications. This implementation follows the
design and optimizations presented in the original paper:\href{https://arxiv.org/abs/1905.02244}{MobileNetV3: Searching for MobileNetV3}

This function mirrors \verb{torchvision::quantization::mobilenet_v3_large} and
loads quantized weights when \code{pretrained} is \code{TRUE}.
}
\details{
The model includes two variants:
\itemize{
\item \code{model_mobilenet_v3_large()}
\item \code{model_mobilenet_v3_small()}
}

Both variants utilize efficient blocks such as inverted residuals, squeeze-and-excitation (SE) modules,
and hard-swish activations for improved accuracy and efficiency.
\subsection{Model Summary and Performance for pretrained weights}{

\if{html}{\out{<div class="sourceCode">}}\preformatted{| Model                  | Top-1 Acc | Top-5 Acc | Params  | GFLOPS | File Size | Notes                               |
|------------------------|-----------|-----------|---------|--------|-----------|-------------------------------------|
| MobileNetV3 Large      | 74.04\%    | 91.34\%    | 5.48M   | 0.22   | 21.1 MB   | Trained from scratch, simple recipe |
| MobileNetV3 Small      | 67.67\%    | 87.40\%    | 2.54M   | 0.06   | 9.8 MB    | Improved recipe over original paper |
}\if{html}{\out{</div>}}
}
}
\section{Functions}{
\itemize{
\item \code{model_mobilenet_v3_large()}: MobileNetV3 Large model with about 5.5 million parameters.

\item \code{model_mobilenet_v3_small()}: MobileNetV3 Small model with about 2.5 million parameters.

}}
\examples{
\dontrun{
# 1. Download sample image (dog)
norm_mean <- c(0.485, 0.456, 0.406) # ImageNet normalization constants, see
# https://pytorch.org/vision/stable/models.html
norm_std  <- c(0.229, 0.224, 0.225)
img_url <- "https://en.wikipedia.org/wiki/Special:FilePath/Felis_catus-cat_on_snow.jpg"
img <- base_loader(img_url)

# 2. Convert to tensor (RGB only), resize and normalize
input <- img \%>\%
 transform_to_tensor() \%>\%
 transform_resize(c(224, 224)) \%>\%
 transform_normalize(norm_mean, norm_std)
batch <- input$unsqueeze(1)

# 3. Load pretrained models
model_small <- model_mobilenet_v3_small(pretrained = TRUE)
model_small$eval()

# 4. Forward pass
output_s <- model_small(batch)

# 5. Top-5 printing helper
topk <- output_s$topk(k = 5, dim = 2)
indices <- as.integer(topk[[2]][1, ])
scores <- as.numeric(topk[[1]][1, ])

# 6. Show Top-5 predictions
glue::glue("{seq_along(indices)}. {imagenet_label(indices)} ({round(scores, 2)}\%)")

# 7. Same with large model
model_large <- model_mobilenet_v3_large(pretrained = TRUE)
model_large$eval()
output_l <- model_large(input)
topk <- output_l$topk(k = 5, dim = 2)
indices <- as.integer(topk[[2]][1, ])
scores <- as.numeric(topk[[1]][1, ])
glue::glue("{seq_along(indices)}. {imagenet_label(indices)} ({round(scores, 2)}\%)")
}

}
\seealso{
Other classification_model: 
\code{\link{model_alexnet}()},
\code{\link{model_convnext}},
\code{\link{model_efficientnet}},
\code{\link{model_efficientnet_v2}},
\code{\link{model_facenet}},
\code{\link{model_inception_v3}()},
\code{\link{model_maxvit}()},
\code{\link{model_mobilenet_v2}()},
\code{\link{model_resnet}},
\code{\link{model_vgg}},
\code{\link{model_vit}}

Other classification_model: 
\code{\link{model_alexnet}()},
\code{\link{model_convnext}},
\code{\link{model_efficientnet}},
\code{\link{model_efficientnet_v2}},
\code{\link{model_facenet}},
\code{\link{model_inception_v3}()},
\code{\link{model_maxvit}()},
\code{\link{model_mobilenet_v2}()},
\code{\link{model_resnet}},
\code{\link{model_vgg}},
\code{\link{model_vit}}
}
\concept{classification_model}
