% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api_core.R
\name{from_toon}
\alias{from_toon}
\title{Parse TOON from string}
\usage{
from_toon(
  text,
  strict = TRUE,
  simplify = TRUE,
  allow_comments = TRUE,
  allow_duplicate_keys = TRUE
)
}
\arguments{
\item{text}{Character scalar or raw vector containing TOON data. If raw,
treated as UTF-8 bytes.}

\item{strict}{Logical. If TRUE (default), enforce strict TOON syntax.}

\item{simplify}{Logical. If TRUE (default), simplify homogeneous arrays to
atomic vectors.}

\item{allow_comments}{Logical. If TRUE (default), allow # and // comments.}

\item{allow_duplicate_keys}{Logical. If TRUE (default), allow duplicate keys
in objects (last-one-wins semantics).}
}
\value{
R object representing the parsed TOON data:
\itemize{
\item object -> named list
\item array -> list or atomic vector (if simplified)
\item primitives -> logical/integer/double/character/NULL
}
}
\description{
Parse TOON from string
}
\examples{
# Parse simple object
from_toon('name: "Alice"\nage: 30')

# Parse array
from_toon('[3]:\n  - 1\n  - 2\n  - 3')

# Parse with comments
from_toon('# comment\nkey: "value"', allow_comments = TRUE)

}
