% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_icat.R
\name{calc_icat}
\alias{calc_icat}
\title{Calculate ICAT (Immune Cell Arrangement Trace) Index}
\arguments{
\item{patientID}{Character. Name of the sample in \code{ldata}.}

\item{tlsID}{Numeric/integer. TLS identifier.}

\item{ldata}{Named list of data frames (optional; defaults to global \code{ldata}).}
}
\value{
Numeric ICAT value.
}
\description{
Quantifies linear/organized arrangement of cells within a TLS using FastICA.
}
\examples{
data(toy_ldata)
ldata <- detect_TLS("ToySample", k = 30, ldata = toy_ldata)  # First detect TLS
if (max(ldata[["ToySample"]]$tls_id_knn) > 0) {
  icat <- calc_icat("ToySample", tlsID = 1, ldata = ldata)
  icat
}
}
