% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dispersion_min_max_functions.R
\name{find_min_disp}
\alias{find_min_disp}
\title{Find the minimally dispersed distribution of an item across corpus parts}
\usage{
find_min_disp(subfreq, partsize, freq_adjust_method = "even")
}
\arguments{
\item{subfreq}{A numeric vector of subfrequencies, i.e. the number of occurrences of the item in each corpus part}

\item{partsize}{A numeric vector specifying the size of the corpus parts}

\item{freq_adjust_method}{Character string indicating which method to use for devising dispersion extremes. See details below. Possible values are \code{"even"} (default) and \code{"pervasive"}}
}
\value{
An integer vector the same length as \code{partsize}
}
\description{
This function returns the (hypothetical) distribution of subfrequencies that represents the smallest possible level of dispersion for a given item across a particular set of corpus parts. It requires a vector of subfrequencies and a vector of corpus part sizes. This distribution is required for the min-max transformation proposed by Gries (2022: 184-191; 2024: 196-208) to obtain frequency-adjusted dispersion scores.
}
\details{
This function creates a hypothetical distribution of the total number of occurrences of the item (i.e. the sum of its subfrequencies) across corpus parts. To obtain the lowest possible level of dispersion, the argument \code{freq_adjust_method} allows the user to choose between two distributional features: pervasiveness (\code{pervasive}) or evenness (\code{even}). For details and explanations, see \code{vignette("frequency-adjustment")}. To obtain the lowest possible level of dispersion, the occurrences are either allocated to as few corpus parts as possible (\code{pervasiveness}), or they are assigned to the smallest corpus part(s) (\code{even}). Since the dispersion of items that occur only once in the corpus (hapaxes) cannot be sensibly measured or manipulated, such items are disregarded; the function returns their observed subfrequencies. The function reuses code segments from Gries's (2025) 'KLD4C' package (from the function \code{most.uneven.distr()}).
}
\examples{
find_min_disp(
  subfreq = c(0,0,1,2,5), 
  partsize = rep(1000, 5),
  freq_adjust_method = "even")

}
\references{
Gries, Stefan Th. 2022. What do (most of) our dispersion measures measure (most)? Dispersion? \emph{Journal of Second Language Studies} 5(2). 171--205. \doi{doi:10.1075/jsls.21029.gri}

Gries, Stefan Th. 2024. \emph{Frequency, dispersion, association, and keyness: Revising and tupleizing corpus-linguistic measures}. Amsterdam: Benjamins. \doi{doi:10.1075/scl.115}

Gries, Stefan Th. 2025. \emph{KLD4C: Gries 2024: Tupleization of corpus linguistics}. R package version 1.01. (available from https://www.stgries.info/research/kld4c/kld4c.html)
}
\author{
Lukas Soenning
}
