% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pool_results.R
\name{pool_results}
\alias{pool_results}
\title{Pooling results using Rubin's Rule}
\usage{
pool_results(dat, cox.fit, conf.level = 0.95)
}
\arguments{
\item{dat}{a list of data.frames from multiple imputation using one alpha or kappa parameter}

\item{cox.fit}{a coxph object which is used to compute HRs for each imputed datasets}

\item{conf.level}{confidence level for the returned confidence interval, default to be 0.95.}
}
\value{
a data.frame of pooled hazard ratio and confidence interval estimate using Rubin's Rule
}
\description{
Pooling results from multiple imputations using Rubin's Rule
}
\details{
The Rubin's rule is applied to the Cox PH model results across imputed datasets as:

\enumerate{
\item \emph{Compute pooled HR:}
\deqn{\bar{HR}_\lambda = \exp\Bigg(\frac{1}{M} \sum_{m=1}^{M} \log(HR_m)\Bigg)}

\item \emph{Compute pooled variance:}
\deqn{\bar{\sigma}_\lambda^2 = \frac{1}{M} \sum_{m=1}^{M} \sigma_m^2 +
  \frac{1 + \frac{1}{M}}{M-1} \sum_{m=1}^{M} \big(\log(HR_m) - \overline{\log(HR_\lambda)}\big)^2}

\item \emph{Compute CI:}
\deqn{\bar{HR}_\lambda \times \exp\big(\pm t_{\alpha/2} \sqrt{\bar{\sigma}_\lambda^2}\big)}
}
}
\keyword{internal}
