% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/2_geo_id.R
\name{geo_download}
\alias{geo_download}
\title{geo_download}
\usage{
geo_download(
  gse,
  by_annopbrobe = TRUE,
  simpd = TRUE,
  colon_remove = FALSE,
  destdir = getwd(),
  n = 1
)
}
\arguments{
\item{gse}{gse assession number}

\item{by_annopbrobe}{download data by geoquery or annoprobe}

\item{simpd}{get simplified pdata,drop out columns with all same values}

\item{colon_remove}{whether to remove duplicated columns with colons}

\item{destdir}{The destination directory for data downloads.}

\item{n}{For data with more than one ExpressionSet, specify which one to analyze}
}
\value{
a list with exp,pd and gpl
}
\description{
download gse data and get informations
}
\examples{
\dontrun{
if(requireNamespace("Biobase",quietly = TRUE)&
   requireNamespace("AnnoProbe",quietly = TRUE)){
  gse = "GSE42872"
  a = geo_download(gse,destdir=tempdir())
}else{
  if(!requireNamespace("AnnoProbe",quietly = TRUE)) {
    print("Package 'AnnoProbe' needed for this function to work.
         Please install it by install.packages('AnnoProbe')"print)
  }
  if(!requireNamespace("Biobase",quietly = TRUE)) {
    print("Package 'Biobase' needed for this function to work.
         Please install it by BiocManager::install('Biobase')"print)
  }
}
}
}
\seealso{
\code{\link{find_anno}}
}
\author{
Xiaojie Sun
}
