% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tzone.R
\name{tzone}
\alias{tzone}
\alias{tzone<-}
\alias{tzone.tind}
\alias{tzone<-.tind}
\alias{tzone.tinterval}
\alias{tzone<-.tinterval}
\alias{tzone.POSIXct}
\alias{tzone<-.POSIXct}
\alias{tzone.POSIXlt}
\alias{tzone<-.POSIXlt}
\title{Read or Set Time Zone for Date-Time Indices}
\usage{
tzone(x)

tzone(x) <- value

\method{tzone}{tind}(x)

\method{tzone}{tind}(x) <- value

\method{tzone}{tinterval}(x)

\method{tzone}{tinterval}(x) <- value

\method{tzone}{POSIXct}(x)

\method{tzone}{POSIXct}(x) <- value

\method{tzone}{POSIXlt}(x)

\method{tzone}{POSIXlt}(x) <- value
}
\arguments{
\item{x}{an object of \code{tind} class or of \code{POSIXct}/\code{POSIXlt}
classes (or of other class for which the method was implemented).}

\item{value}{a character value, the new time zone attribute.}
}
\value{
For the extractor, the time zone as a character value (or \code{NULL}
for classes without time zone attribute). For the replacement, the argument
with the modified time zone.
}
\description{
Date-time indices (objects of \code{tind} class of type \code{"t"})
always have the time zone attribute set. The time zone setting affects
how time (measured relative to the Unix epoch in UTC) is translated to local
time. Objects of base \code{POSIXct} and \code{POSIXlt} classes also have
an optional time zone attribute. \code{tzone} method is also implemented for some
other classes supported by the \pkg{tind} package.

List of time zones supported by a particular R installation can be obtained
via a call to \code{\link[base]{OlsonNames}} function, see Examples.
}
\details{
If the provided name is not in the list of supported time zones,
an attempt is made to identify it via approximate match. If the result is
a single time zone, it is accepted with a warning.

Unambiguous city names are automatically recognised, see Examples.

An attempt to set time zone attribute of a time index
of different type than date-time (\code{"t"}) will lead to an error.
In case of \code{POSIXct}/\code{POSIXlt} objects with no time zone attribute,
the extractor returns the system time zone.
}
\examples{
# check time in the system time zone
(nw <- now())
# get time zone
tzone(nw)
# set time zone to UTC
tzone(nw) <- "UTC"
nw
tzone(nw)
# check time in different time zones
if ("Asia/Tokyo" \%in\% OlsonNames()) {
tzone(nw) <- "Asia/Tokyo"
nw
}
if ("Europe/Warsaw" \%in\% OlsonNames()) {
tzone(nw) <- "Europe/Warsaw"
nw
}
if ("America/New_York" \%in\% OlsonNames()) {
tzone(nw) <- "America/New_York"
nw
}
# try invalid time zone => error
try(
tzone(nw) <- "Hasdfg/Qwerty"
)
# unambiguous city names are automatically recognised
tzone(nw) <- "Tokyo"
nw
tzone(nw) <- "Warsaw"
nw
tzone(nw) <- "New York"
nw
# incomplete names and approximate matches are also recognised with a warning
if ("Europe/Warsaw" \%in\% OlsonNames()) try({
tzone(nw) <- "Warsa"
nw
})
if ("America/New_York" \%in\% OlsonNames()) try({
tzone(nw) <- "NewYork"
nw
})

# list first 6 supported time zones using base::OlsonNames
head(OlsonNames())
# list first 6 supported time zones with string "Europe"
head(grep("Europe", OlsonNames(), value = TRUE))
# list first 6 supported time zones with string "Asia"
head(grep("Asia", OlsonNames(), value = TRUE))
# list first 6 supported time zones with string "Africa"
head(grep("Africa", OlsonNames(), value = TRUE))
# list first 6 supported time zones with string "America"
head(grep("America", OlsonNames(), value = TRUE))

}
\seealso{
\code{\link{as.tzone}}.
}
