% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/timeseries.R
\name{change_timeseries_tzone}
\alias{change_timeseries_tzone}
\title{Adapt the timezone of a time series dataframe}
\usage{
change_timeseries_tzone(dtf, tzone = "Europe/Amsterdam")
}
\arguments{
\item{dtf}{data.frame or tibble, first column of name \code{datetime} being
of class datetime and rest of columns being numeric}

\item{tzone}{character, desired time-zone of the datetime sequence}
}
\value{
tibble
}
\description{
The timezone of the \code{datetime} column is changed while
keeping the same date time sequence.
This is useful when the time series data is known to be in a different timezone.
If you just want the same time series in a different timezone,
use \code{lubridate::force_tz} function instead.
}
\examples{
# Example data set
get_timeseries_tzone(dtf)
range(dtf$datetime)

#  Change timezone
new_dtf <- change_timeseries_tzone(dtf, tzone = "Europe/Paris")
get_timeseries_tzone(new_dtf)
range(new_dtf$datetime)

}
