% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tw_get_qualifiers.R
\name{tw_get_qualifiers_single}
\alias{tw_get_qualifiers_single}
\title{Get Wikidata qualifiers for a given property of a given item}
\usage{
tw_get_qualifiers_single(
  id,
  p,
  language = tidywikidatar::tw_get_language(),
  cache = NULL,
  overwrite_cache = FALSE,
  cache_connection = NULL,
  disconnect_db = TRUE,
  wait = 0,
  id_l = NULL
)
}
\arguments{
\item{id}{A character vector, must start with Q, e.g. "Q180099" for the
anthropologist Margaret Mead. Can also be a data frame of one row,
typically generated with \code{\link[=tw_search]{tw_search()}} or a combination of \code{\link[=tw_search]{tw_search()}}
and \code{\link[=tw_filter_first]{tw_filter_first()}}.}

\item{p}{A character vector, a property. Must always start with the capital
letter "P", e.g. "P31" for "instance of".}

\item{language}{Defaults to language set with \code{\link[=tw_set_language]{tw_set_language()}}; if not
set, "en". Use "all_available" to keep all languages. For available
language values, see
\href{https://www.wikidata.org/wiki/Help:Wikimedia_language_codes/lists/all}{the
dedicated Wikimedia page}.}

\item{cache}{Defaults to \code{NULL}. If given, it should be given either \code{TRUE}
or \code{FALSE}. Typically set with \code{\link[=tw_enable_cache]{tw_enable_cache()}} or \code{\link[=tw_disable_cache]{tw_disable_cache()}}.}

\item{overwrite_cache}{Logical, defaults to \code{FALSE}. If \code{TRUE}, it overwrites
the table in the local sqlite database. Useful if the original Wikidata
object has been updated.}

\item{cache_connection}{Defaults to \code{NULL}. If \code{NULL}, and caching is
enabled, \code{tidywikidatar} will use a local sqlite database. A custom
connection to other databases can be given (see vignette \code{caching} for
details).}

\item{disconnect_db}{Defaults to \code{TRUE}. If \code{FALSE}, leaves the connection to
cache open.}

\item{wait}{In seconds, defaults to 0. Time to wait between queries to
Wikidata. If data are cached locally, wait time is not applied. If you are
running many queries systematically you may want to add some waiting time
between queries.}

\item{id_l}{Defaults to \code{NULL}. If given, must be an object or list such as
the one generated with \code{\link[=tw_get_item]{tw_get_item()}}. If given, and the requested
id is actually present in \code{id_l}, then no query to Wikidata servers is
made.}
}
\value{
A data frame (a tibble) with eight columns: \code{id} for the input id,
\code{property},  \code{qualifier_id}, \code{qualifier_property}, \code{qualifier_value},
\code{rank}, \code{qualifier_value_type}, and \code{set} (to distinguish sets of data when
a property is present more than once)
}
\description{
N.B. In order to provide for consistently structured output, this function
outputs either id or value for each  qualifier. The user should keep in mind
that some of these come with additional detail (e.g. the unit, precision, or
reference calendar).
}
\examples{
if (interactive()) {
  tidywikidatar:::tw_get_qualifiers_single(id = "Q180099", p = "P26", language = "en")
}

#' ## using `tw_test_items` in examples in order to show output without calling
## on Wikidata servers

tidywikidatar:::tw_get_qualifiers_single(
  id = "Q180099",
  p = "P26",
  language = "en",
  id_l = tw_test_items
)
}
