% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tt_submit.R
\name{tt_submit}
\alias{tt_submit}
\title{Submit a TidyTuesday dataset}
\usage{
tt_submit(
  path = "tt_submission",
  auth = gh::gh_token(),
  open = rlang::is_interactive()
)
}
\arguments{
\item{path}{The relative path to the directory to hold your submission files
(\code{tt_submission} by default). If this directory does not exist, it will be
created.}

\item{auth}{A GitHub token. See \code{\link[gh:gh_token]{gh::gh_token()}} for more details.}

\item{open}{Whether to open the pull request in a browser. Defaults to \code{TRUE}
in an interactive session.}
}
\value{
The URL of the pull request, invisibly.
}
\description{
Submit a curated dataset for review by uploading it to GitHub and creating a
pull request. The dataset should be prepared using \code{\link[=tt_clean]{tt_clean()}},
\code{\link[=tt_save_dataset]{tt_save_dataset()}}, \code{\link[=tt_intro]{tt_intro()}}, and \code{\link[=tt_meta]{tt_meta()}}. You can also use this
function to submit changes to your local copies of the files.
}
\examples{
\dontshow{if (interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# First set up a dataset in the "tt_submission" folder.
tt_submit()
\dontshow{\}) # examplesIf}
}
