% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/replace-na-Spat.R
\name{replace_na.Spat}
\alias{replace_na.Spat}
\alias{replace_na.SpatRaster}
\alias{replace_na.SpatVector}
\title{Replace \code{NA}s with specified values}
\usage{
\method{replace_na}{SpatRaster}(data, replace = list(), ...)

\method{replace_na}{SpatVector}(data, replace, ...)
}
\arguments{
\item{data}{A \code{SpatRaster} created with \code{\link[terra:rast]{terra::rast()}} or a \code{SpatVector}
created with \code{\link[terra:vect]{terra::vect()}}.}

\item{replace}{list of values, with one value for each layer/attribute that
has \code{NA} values to be replaced.}

\item{...}{Ignored}
}
\value{
A \verb{Spat*} object  of the same class than \code{data}. Geometries and
spatial attributes are preserved.
}
\description{
Replace \code{NA} values on layers/attributes with specified values
}
\section{\CRANpkg{terra} equivalent}{


Use \verb{r[is.na(r)] <- <replacement>}
}

\examples{

library(terra)

f <- system.file("extdata/cyl_temp.tif", package = "tidyterra")
r <- rast(f)

r |> plot()

r |>
  replace_na(list(tavg_04 = 6, tavg_06 = 20)) |>
  plot()

}
\seealso{
\code{\link[tidyr:replace_na]{tidyr::replace_na()}}

Other \CRANpkg{tidyr} verbs for handling missing values:
\code{\link{drop_na.Spat}},
\code{\link{fill.SpatVector}()}

Other \CRANpkg{tidyr} methods:
\code{\link{drop_na.Spat}},
\code{\link{fill.SpatVector}()},
\code{\link{pivot_longer.SpatVector}()},
\code{\link{pivot_wider.SpatVector}()}
}
\concept{tidyr.methods}
\concept{tidyr.missing}
