% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{princess_db}
\alias{princess_db}
\title{Princess palettes database}
\format{
A \link[tibble:tbl_df-class]{tibble} of 75 rows and
5 columns. with the following fields:

\describe{
\item{pal}{ Name of the palette.}
\item{r}{Value of the red channel (RGB color mode).}
\item{g}{Value of the green channel (RGB color mode).}
\item{b}{Value of the blue channel (RGB color mode).}
\item{hex}{ Hex code of the color.}
}
}
\source{
\url{https://leahsmyth.github.io/Princess-Colour-Schemes/index.html}.
}
\description{
A \link[tibble:tbl_df-class]{tibble} including the color map of
15 gradient palettes.
}
\examples{
\donttest{
data("princess_db")

princess_db

# Select a palette
maori <- princess_db |>
  filter(pal == "maori")

f <- system.file("extdata/volcano2.tif", package = "tidyterra")
r <- terra::rast(f)

library(ggplot2)

p <- ggplot() +
  geom_spatraster(data = r) +
  labs(fill = "elevation")

p +
  scale_fill_gradientn(colors = maori$hex)
}
}
\seealso{
\code{\link[=scale_fill_princess_c]{scale_fill_princess_c()}}

Other datasets: 
\code{\link{cross_blended_hypsometric_tints_db}},
\code{\link{grass_db}},
\code{\link{hypsometric_tints_db}},
\code{\link{volcano2}}
}
\concept{datasets}
