% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as-spatraster.R
\name{as_spatraster}
\alias{as_spatraster}
\title{Coerce a data frame to \code{SpatRaster}}
\usage{
as_spatraster(x, ..., xycols = 1:2, crs = "", digits = 6)
}
\arguments{
\item{x}{A \link[tibble:tbl_df-class]{tibble} or data frame.}

\item{...}{additional arguments passed on to \code{\link[terra:rast]{terra::rast()}}.}

\item{xycols}{A vector of integers of length 2 determining the position of
the columns that hold the x and y coordinates.}

\item{crs}{A crs on several formats (PROJ.4, WKT, EPSG code, ..) or
and spatial object from \strong{\link[sf:st_crs]{sf}} or
\strong{\link[terra:crs]{terra}}.
that includes the target coordinate reference system. See \code{\link[=pull_crs]{pull_crs()}} and
\strong{Details}.}

\item{digits}{integer to set the precision for detecting whether points are
on a regular grid (a low number of digits is a low precision).}
}
\value{
A \code{SpatRaster}.
}
\description{
\code{as_spatraster()} turns an existing  data frame or \link[tibble:tbl_df-class]{tibble}
into a \code{SpatRaster}. This is a wrapper of \code{\link[terra:rast]{terra::rast()}} S4 method for
signature \code{data.frame}.
}
\details{
If no \code{crs} is provided and the tibble has been created with the method
\code{\link[=as_tibble.SpatRaster]{as_tibble.SpatRaster()}}, the \code{crs} is inferred from
\code{\link[=attr]{attr(x, "crs")}}.
}
\section{\CRANpkg{terra} equivalent}{


\code{\link[terra:rast]{terra::rast()}} (see S4 method for signature \code{data.frame}).
}

\examples{
library(terra)

r <- rast(matrix(1:90, ncol = 3), crs = "EPSG:3857")

r

# Create tibble
as_tbl <- as_tibble(r, xy = TRUE)

as_tbl

# From tibble
newrast <- as_spatraster(as_tbl, crs = "EPSG:3857")
newrast

}
\seealso{
\code{\link[=pull_crs]{pull_crs()}} for retrieving crs, and the corresponding utils \code{\link[sf:st_crs]{sf::st_crs()}}
and \code{\link[terra:crs]{terra::crs()}}.

Coercing objects:
\code{\link{as_coordinates}()},
\code{\link{as_sf}()},
\code{\link{as_spatvector}()},
\code{\link{as_tibble.Spat}},
\code{\link{fortify.Spat}},
\code{\link{tidy.Spat}}
}
\concept{coerce}
