% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tune_synthesis.R
\name{tune_synthesis}
\alias{tune_synthesis}
\title{Generate syntheses from multiple \code{presynth} objects.}
\usage{
tune_synthesis(
  presynths,
  postprocessing_func,
  metadata_func = NULL,
  simplify_post = FALSE,
  seed = NULL
)
}
\arguments{
\item{presynths}{A list of \code{presynth} objects}

\item{postprocessing_func}{A function with arguments "synth_id", "synth_name",
and "postsynth" that performs any desired postprocessing operations, like writing}

\item{metadata_func}{An optional function with argument "presynth" that extracts
specified information from each \code{presynth} object and returns a list. Each list
element becomes an additional column in the output metadata.}

\item{simplify_post}{Boolean that, if true, expects \code{postprocessing_func} to
return a list corresponding to the row of the output dataframe (one per synthesis).}

\item{seed}{A RNG seed to pass to \code{set.seed()}}
}
\value{
A \code{post_tunesynth} object.
}
\description{
Generate syntheses from multiple \code{presynth} objects.
}
\examples{

rm <- roadmap(
  conf_data = acs_conf_nw,
  start_data = acs_start_nw
) 

dt_mod_reg <- parsnip::decision_tree() |>
  parsnip::set_engine(engine = "rpart") |>
  parsnip::set_mode(mode = "regression")

dt_mod_reg_cp <- parsnip::decision_tree(cost_complexity = 0.01) |>
  parsnip::set_engine(engine = "rpart") |>
  parsnip::set_mode(mode = "regression")

dt_mod_class <- parsnip::decision_tree() |>
  parsnip::set_engine(engine = "rpart") |>
  parsnip::set_mode(mode = "classification")

# synth specs
synth_spec1 <- synth_spec(
  default_regression_model = dt_mod_reg,
  default_regression_sampler = sample_rpart,
  default_classification_model = dt_mod_class,
  default_classification_sampler = sample_rpart
)

synth_spec2 <- synth_spec(
  default_regression_model = dt_mod_reg_cp,
  default_regression_sampler = sample_rpart,
  default_classification_model = dt_mod_class,
  default_classification_sampler = sample_rpart
)


presynth1 <- presynth(
  roadmap = rm,
  synth_spec = synth_spec1
)

presynth2 <- presynth(
  roadmap = rm,
  synth_spec = synth_spec2
)

postproc_f_null <- function(synth_id, synth_name, postsynth) {
  return(postsynth[["synthetic_data"]])
}

tune_synthesis(
  presynths = list(presynth1, presynth2),
  postprocessing_func = postproc_f_null,
  seed = 12345
)



}
