% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/start_method.R
\name{start_method}
\alias{start_method}
\title{Create a \code{start_method} object.}
\usage{
start_method(start_func = NULL, ...)
}
\arguments{
\item{start_func}{A function that accepts and returns a \code{data.frame}. If none
provided \code{.identity_start()} is used.}

\item{...}{Optional keyword arguments passed to \code{start_func(...)}}
}
\value{
A \code{start_method} object
}
\description{
A \code{start_method} gets executed prior to running a synthesis. This modifies
the \code{start_data}, typically randomly, to provide greater disclosure risk
protections.
}
\examples{

# basic usage
start_method(start_func = start_resample)

# adjust the number of observations
start_method(
  start_func = start_resample,
  start_data = acs_start_nw,
  n = 10
)

# adjust the number of observations and use all combinations as support
start_method(
  start_func = start_resample,
  start_data = acs_start_nw,
  n = 10, 
  inv_noise_scale = 1,
  support = "all"
)

}
