% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/noise.R
\name{noise}
\alias{noise}
\title{Create a noise object}
\usage{
noise(add_noise = FALSE, mode = "regression", noise_func = NULL, ...)
}
\arguments{
\item{add_noise}{Boolean, TRUE if adding noise}

\item{mode}{String, one of "regression" or "classification"}

\item{noise_func}{A function that adds noise to}

\item{...}{Optional named additional arguments to pass to \code{noise_func(...)}}
}
\value{
A \code{noise} object
}
\description{
Create a noise object
}
\examples{

# create default noise object
noise()

# create noise object for classification
noise(
  add_noise = TRUE,
  mode = "classification",
  noise_func = add_noise_cat_unif
)

# create noise object for regression
noise(
  add_noise = TRUE,
  mode = "regression",
  noise_func = add_noise_kde,
  n_ntiles = 10
)

}
