% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/invert.R
\name{invert.step_log}
\alias{invert.step_log}
\title{Invert a log transformation}
\usage{
\method{invert}{step_log}(object, predictions, ...)
}
\arguments{
\item{object}{A recipe after fitting a model}

\item{predictions}{A data frame with .pred}

\item{...}{Other arguments}
}
\value{
A tibble with the log transformation inverted for .pred
}
\description{
Invert a log transformation
}
\examples{

data <- tibble::tibble(
  y = rlnorm(n = 1000, meanlog = 0, sdlog = 1),
  x = rnorm(n = 1000)
)

adj <- recipes::recipe(y ~ x, data = data) |>
  recipes::step_log(recipes::all_outcomes()) |>
  recipes::prep()
  
invert(
  object = adj$steps[[1]], 
  predictions = tibble::tibble(.pred = adj[["template"]][["y"]])
)

}
