% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/util-methods.R
\name{as.matrix.sq}
\alias{as.matrix.sq}
\title{Convert sq object into matrix}
\usage{
\method{as.matrix}{sq}(x, ...)
}
\arguments{
\item{x}{[\code{sq}]\cr
An object this function is applied to.}

\item{...}{further arguments to be passed from or to other methods.}
}
\value{
A \code{\link{matrix}} with number of rows the same as number of
sequences and number of columns corresponding to the length of the longest
sequence in the converted sq object.
}
\description{
Coerces sequences from a \code{\link[=sq-class]{sq}} object to
a \code{\link{matrix}}, in which rows correspond to sequences and columns to
positions.
}
\details{
This method for class \code{sq} allows converting sequences from the
\code{sq} object into a matrix. Each row corresponds to the separate sequence
from the \code{sq} object, whereas each column indicates a single position
within a sequence. Dimensions of matrix are determined by the number of
sequences (rows) and the length of the longest sequence (columns). If length
of a sequence is smaller than the length of the longest sequence, the
remaining columns are filled with \code{NA}. All attributes of the input
\code{sq} are lost during the conversion to matrix.
}
\examples{
# Creating objects to work on:
sq_dna <- sq(c("CGATAGACA", "TGACAAAAC", "GTGACCGTA"),
             alphabet = "dna_bsc")
sq_rna <- sq(c("CUGAAUGCAGUACCGUAAU", "AUGCCGUAAAUGCCAU", "CAGACCANNNAUAG"),
             alphabet = "rna_ext")

# Sequences of the same lengths can be converted easily:
as.matrix(sq_dna)

# Sequences that differ in length are filled with NA to the maximum length:
as.matrix(sq_rna)

}
\seealso{
Functions from output module:
\code{\link{as.character.sq}()},
\code{\link{as.sq}()},
\code{\link{export_sq}()},
\code{\link{write_fasta}()}
}
\concept{output_functions}
