% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spec_trans2abs.R
\name{spec_trans2abs}
\alias{spec_trans2abs}
\title{Convert Spectral Data from Transmittance to Absorbance}
\usage{
spec_trans2abs(.data, wn_col = NULL)
}
\arguments{
\item{.data}{A `data.frame` or `tibble` containing spectral data.}

\item{wn_col}{A character string specifying the column name for the wavelength data. Default is `"Wn"`.}
}
\value{
A `tibble` with the converted absorbance data, containing the wavelength column and the absorbance numeric columns.
}
\description{
This function converts transmittance data to absorbance using the formula `A = 2 - log10(T)`, where `T` is the transmittance. It also filters out any infinite values resulting from the transformation, while preserving the wavelength column.
}
