% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/age_depth_model.R
\name{predict.age_depth_model}
\alias{predict.age_depth_model}
\alias{predict_depth}
\alias{predict_age}
\title{Predict age and depth values}
\usage{
\method{predict}{age_depth_model}(object, .data = NULL, depth = NULL, age = NULL, ...)

predict_depth(object, age)

predict_age(object, depth)
}
\arguments{
\item{object}{An \link{age_depth_model} object}

\item{.data}{Optional input data frame}

\item{depth, age}{Specify exactly one of these to predict the other.}

\item{...}{Unused}
}
\value{
A data frame with the same number of observations as the input age or
depth vector.
}
\description{
Predict age and depth values
}
\examples{
adm <- age_depth_model(
  alta_lake_210Pb_ages,
  depth = depth_cm, age = age_year_ad,
  age_max = age_year_ad + age_error_yr,
  age_min = age_year_ad - age_error_yr
)

predict(adm, depth = 1:5)

}
