% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/age_depth_model.R
\name{plot.age_depth_model}
\alias{plot.age_depth_model}
\title{Plot an age depth model using base graphics}
\usage{
\method{plot}{age_depth_model}(
  x,
  xlab = "depth",
  ylab = "age",
  xlim = NULL,
  ylim = NULL,
  add = FALSE,
  ...
)
}
\arguments{
\item{x}{An \link{age_depth_model}}

\item{xlab, ylab}{Axis labels}

\item{xlim, ylim}{Axis limits}

\item{add}{Pass TRUE to skip creating a new plot}

\item{...}{Passed to \link[graphics:points]{points} to customize points display}
}
\value{
The input, invisibly
}
\description{
Plot an age depth model using base graphics
}
\examples{
adm <- age_depth_model(
  alta_lake_210Pb_ages,
  depth = depth_cm, age = age_year_ad,
  age_max = age_year_ad + age_error_yr,
  age_min = age_year_ad - age_error_yr
)

plot(adm)

}
