% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggstrat-labels.R
\name{label_species}
\alias{label_species}
\title{Species facet labellers}
\usage{
label_species(
  labels,
  dont_italicize = c("\\\\(.*?\\\\)", "spp?\\\\.", "-complex", "[Oo]ther"),
  species_facet = 1,
  multi_line = TRUE
)
}
\arguments{
\item{labels}{A data.frame of facet label values}

\item{dont_italicize}{Regular expressions that should not be italicized}

\item{species_facet}{Which facet(s) contain species values}

\item{multi_line}{See \link[ggplot2:labellers]{label_parsed}}
}
\value{
A \code{\link[ggplot2:labeller]{ggplot2::labeller()}}
}
\description{
Use these to label species with partial italic formatting. See \link[ggplot2:labellers]{label_parsed}.
}
\examples{

library(ggplot2)

ggplot(keji_lakes_plottable, aes(x = rel_abund, y = depth)) +
  geom_col_segsh() +
  scale_y_reverse() +
  facet_grid(
    cols = vars(taxon),
    rows = vars(location),
    scales = "free_x",
    space = "free_x",
    labeller = purrr::partial(label_species, species_facet = "taxon")
  ) +
  labs(y = "Depth (cm)")

}
